tinymce.PluginManager.add('placeholder', function (editor) {
  editor.on('init', function () {
    var label = new Label;

    onBlur();

    tinymce.DOM.bind(label.el, 'click', onFocus);
    editor.on('focus', onFocus);
    editor.on('blur', onBlur);
    editor.on('change', onBlur);

    function onFocus() {
      label.hide();
      editor.execCommand('mceFocus', false);
    }

    function onBlur() {
      if (editor.getContent() == '') {
        label.show();
      } else {
        label.hide();
      }
    }
  });

  var Label = function () {
    // Create label el
    this.text = editor.getElement().getAttribute("placeholder");
    this.contentAreaContainer = editor.getContentAreaContainer();

    tinymce.DOM.setStyle(this.contentAreaContainer, 'position', 'relative');

    attrs = {
      style: {
        position: 'absolute',
        top: 0,
        left: 0,
        bottom: 0,
        color: '#6c868e',
        'font-style': 'italic',
        padding: '1%',
        width: '98%',
        overflow: 'hidden',
        'white-space': 'normal'
      }
    };
    this.el = tinymce.DOM.add(this.contentAreaContainer, "div", attrs, this.text);
  }

  Label.prototype.hide = function () {
    tinymce.DOM.setStyle(this.el, 'display', 'none');
  }

  Label.prototype.show = function () {
    tinymce.DOM.setStyle(this.el, 'display', '');
  }
});
